<?PHP
    if(isset($_POST['return']) && $_POST['return'] == "1") {
        $apache_location = $_POST['apache_location'];
        $apache_ip = $_POST['apache_ip'];
        $domain = $_POST['domain'];
        $document_root = $_POST['document_root'];
        $apache_location = str_replace("\\","/",$apache_location);
        $document_root = str_replace("\\","/",$document_root);
        $php_location = $_POST['php_location'];
        
        $imap_host = $_POST['imap_host'];
        $imap_port = $_POST['imap_port'];
        $smtp_host = $_POST['smtp_host'];
        $smtp_port = $_POST['smtp_port'];
    
        $ldap_host = $_POST['ldap_host'];
        $ldap_port = $_POST['ldap_port'];
        $ldap_base_domain = $_POST['ldap_base_domain'];
        $ldap_search_user = $_POST['ldap_search_user'];
        $ldap_search_password = $_POST['ldap_search_password'];
        $ldap_admin_user = $_POST['ldap_admin_user'];
        $ldap_admin_password = $_POST['ldap_admin_password'];
        $ldap_ssl_location = $_POST['ldap_ssl_location'];
        
        $db_data_location = $_POST['db_data_location'];
        $db_logs_location = $_POST['db_logs_location'];
        $db_fqdn = $_POST['db_fqdn'];
        $db_instance = $_POST['db_instance'];
        $db_port = $_POST['db_port'];
        $db_user = $_POST['db_user'];
        $db_password = $_POST['db_password'];
   
        $webmail_user = $_POST['webmail_user'];
        $webmail_password = $_POST['webmail_password'];
        $key = $_POST['key'];
        $encrypt = new CI_Encrypt();
        $ep = $encrypt->encode($webmail_password,$key);
    
        $attributes = array();
        $attributes["objectClass"] = array("posixAccount", "top", "person", "organizationalPerson", "inetOrgPerson");
        $attributes["gidNumber"] = "5000";
        $attributes["uidNumber"] = "5000";
        $attributes["uid"] = $webmail_user;
        $attributes["homeDirectory"] = "/var/mailboxes/" . $webmail_user;
        $attributes["cn"] = "Webmail Administrator";
        $attributes["givenName"] = "Webmail";
        $attributes["sn"] = "Administrator";
        $attributes["mail"] = $webmail_user . "@" . $domain;
        $attributes["userPassword"] = ssha_encode($webmail_password);
    
        $ldap_conn = ldap_connect($ldap_host, $ldap_port);
        if($ldap_conn) {
            ldap_set_option($ldap_conn, LDAP_OPT_PROTOCOL_VERSION, 3);
            ldap_set_option($ldap_conn, LDAP_OPT_REFERRALS, 0);
            if(ldap_bind($ldap_conn, $ldap_admin_user, $ldap_admin_password)) {
                if(ldap_add($ldap_conn, "uid=" . $attributes["uid"] . ",ou=accounts," . $ldap_base_domain,$attributes)) {
                    if(ldap_mod_add($ldap_conn,"ou=admins,".$ldap_base_domain,array("member" => "uid=" . $webmail_user . ",ou=accounts," . $ldap_base_domain))) {
                        $message = "Added initial webmail admin in LDAP.";
                    }
                    else { 
                        $message = "Failed to add initial webmail user to admin group in LDAP. PHP error: ";
                        $message .= ldap_error($ldap_conn); 
                    }
                }   
                else { 
                    $message = "Failed to add initial webmail admin in LDAP. PHP error: ";
                    $message .= ldap_error($ldap_conn); 
                }
            }
            else { $message = "Failed to bind to LDAP to create initial webmail admin.";  }
        }
        else { $message = "Failed to connect to LDAP server to create initial webmail admin."; }
        $sql_query = 'INSERT [dbo].[users] ([user_edipi], [user_piv_id], [user_name], [user_mail], [user_theme], [user_ep], [user_created_by], [user_created_date], [user_ext_notify_flag], [user_ext_group_notify_flag], [user_deleted_flag],[user_is_group]) VALUES (1, NULL, NULL, N\'' . $webmail_user . '\', N\'\', 1, N\'' . $ep .'\', 0, 0, 0, 0, 0, 0)';
   		$message .= '<div style="width: 800px;"><p>Provide the following SQL query to the DBA to run manually <b>after</b> running the direct.sql file.</p><pre style="width: 800px; word-wrap: break-word;">'.$sql_query.'</pre></div>';
    }
?>
<!doctype html>
<html>
    <head>
        <title>Installation</title>
        <style>
            body {
                font-size: 12px;
                font-family: Helvetica,"Helvetica Neue",Arial,sans-serif; 
                background: #01243B;
            }
            #wrapper {
                margin-right: auto;
                margin-left: auto;
                width: 900px;
            }
            #header { 
                margin-top: 25px; 
                background: #bbb;
                padding: 25px;
                text-align: center;
            }
                #header h1 {
                    margin: 0;
                    font-size: 18px;
                }
            #content {
                background: #fff;
                padding: 10px;
            }
            #content table {
                margin-left: auto;
                margin-right: auto;
                width: 850px;
            }
                #content table td {
                    width: 250px;
                }
                #content table td input {
                    width: 450px;
                }
        </style>
    </head>
    <body>
        <div id="wrapper">
            <div id="header">
                <h1>Direct Project Installation</h1>
            </div>
            <div id="content">
                <form method="POST" action="install.php">
                    <?PHP if(isset($message)) { echo $message; } ?>
                    <h3>General Information</h3>
                    <table>
                        <tr><td>Domain</td><td><input type="text" name="domain" /></td></tr>
                        <tr><td></td><td>(e.g. direct.example.com)</td></tr>
                        <tr><td>Encryption Key</td><td><input type="text" name="key" /></td></tr>
                        <tr><td></td><td>Encryption key to use for AES encryption in the application (should be complex)</td></tr>
                    </table>
                    
                    <h3>Mail Server Information</h3>
                    <table>
                        <tr><td>IMAP Hostname</td><td><input type="text" name="imap_host" /></td></tr>
                        <tr><td></td><td>Hostname or IP Address of IMAP server (eg. mail01.direct.example.com or 10.255.213.23)</td></tr>
                        <tr><td>IMAP Port</td><td><input type="text" name="imap_port" /></td></tr>
                        <tr><td></td><td>Default port for IMAP is 143, default for IMAPS is 993</td></tr>
                        <tr><td>SMTP Hostname</td><td><input type="text" name="smtp_host" /></td></tr>
                        <tr><td></td><td>Hostname or IP Address of STMP server (eg. mail01.direct.example.com or 10.255.213.23)</td></tr>
                        <tr><td>SMTP Port</td><td><input type="text" name="smtp_port" /></td></tr>
                        <tr><td></td><td>Default port for SMTP is 25, default for SMTPS is 465</td></tr>
                    </table>
                    
                    <h3>Apache Information</h3>
                    <table>
                         <tr><td>Apache IP Address</td><td><input type="text" name="apache_ip" /></td></tr>
                        <tr><td></td><td>IP Address for Apache to listen on (IP of web server)</td></tr>
                        <tr><td>Apache Install Location</td><td><input type="text" name="apache_location" /></td></tr>
                        <tr><td></td><td>Location of Apache installation (default C:\Program Files (x86)\Apache Software Foundation\Apache2.2)</td></tr>
                         <tr><td>PHP Install Location</td><td><input type="text" name="php_location" /></td></tr>
                        <tr><td></td><td>Location of PHP Installation (used to configure Apache)</td></tr>
                        <tr><td>Apache Document Root</td><td><input type="text" name="document_root" /></td></tr>
                        <tr><td></td><td>Location of Apache htdocs folder (should be a seperate partition, W:\htdocs if following suggested installation)</td></tr>
                    </table>
                    
                    <h3>Database Information</h3>
                    <table>
                        <tr><td>Database Fully Qualified Domain Name</td><td><input type="text" name="db_fqdn" /></td></tr>
                        <tr><td></td><td>(e.g. db01.direct.example.com)</td></tr>
                        <tr><td>Database Instance Name</td><td><input type="text" name="db_instance" /></td></tr>
                        <tr><td></td><td>Name of the database instance (default is MSSQLSERVER)</td></tr>
                        <tr><td>Database Port</td><td><input type="text" name="db_port" /></td></tr>
                        <tr><td></td><td>TCP port for SQL Server (default is 1433)</td></tr>
                        <tr><td>Database Data Location</td><td><input type="text" name="db_data_location" /></td></tr>
                        <tr><td></td><td>Location for database data files (should be on seperate partition)</td></tr>
                        <tr><td>Database Logs Location</td><td><input type="text" name="db_logs_location" /></td></tr>
                        <tr><td></td><td>Location for database log files (should be on seperate partition, and not the same as data files)</td></tr>
                        <tr><td>Database User</td><td><input type="text" name="db_user" /></td></tr>
                        <tr><td></td><td>Database account with read/write permission on direct database</td></tr>
                        <tr><td>Database Password</td><td><input type="password" name="db_password" /></td></tr>
                        <tr><td></td><td>Password for the above account</td></tr>
                    </table>
                    
                    <h3>LDAP Information</h3>
                    <table>
                        <tr><td>LDAP Hostname</td><td><input type="text" name="ldap_host" value="vadirappprd10.aac.domain"/></td></tr>
                        <tr><td></td><td>Hostname or IP address of LDAP server (Note: if using SSL connection, must prefix with ldaps://, e.g. ldaps://10.255.123.321)</td></tr>
                        <tr><td>LDAP Port</td><td><input type="text" name="ldap_port" value="389"/></td></tr>
                        <tr><td></td><td>Port for LDAP (389 is default for LDAP, 636 is default for LDAPS)</td></tr>
                        <tr><td>LDAP Base Domain</td><td><input type="text" name="ldap_base_domain" value="dc=direct,dc=va,dc=gov"/></td></tr>
                        <tr><td></td><td>Base Domain for the LDAP directory. (e.g. dc=direct,dc=example,dc=com)</td></tr>
                        <tr><td>LDAP Search User</td><td><input type="text" name="ldap_search_user" value="cn=webmailsearch,dc=direct,dc=va,dc=gov"/></td></tr
                         <tr><td></td><td>Distinguished Name of the account set up in LDAP to perform user searches as part of the application. (e.g. cn=webmailsearch,dc=example,dc=com)</td></tr>
                        <tr><td>LDAP Search User Password</td><td><input type="password" name="ldap_search_password" /></td></tr>
                        <tr><td></td><td>Password for the above account</td></tr>
                        <tr><td>LDAP Admin User</td><td><input type="text" name="ldap_admin_user" value="cn=admin,dc=direct,dc=va,dc=gov"/></td></tr
                         <tr><td></td><td>Distinguished Name of the LDAP admin account, used to create initial webmail user in directory.(e.g. cn=admin,dc=example,dc=com)</td></tr>
                        <tr><td>LDAP Admin User Password</td><td><input type="password" name="ldap_admin_password" /></td></tr>
                        <tr><td></td><td>Password for the above account</td></tr>
                        <tr><td>LDAP SSL Certificate Location</td><td><input type="text" name="ldap_ssl_location" /></td></tr>
                        <tr><td></td><td>Full directory path to CA certificate (including filename) for LDAPS communication.</td></tr>
                    </table>
                   
                    <h3>Webmail Information</h3>
                    <table>
                        <tr><td>Webmail Administrator</td><td><input type="text" name="webmail_user" /></td></tr>
                        <tr><td></td><td>Username to create first webmail administrator account, which can be used to set up additional accounts.</td></tr>
                        <tr><td>Webmail Password</td><td><input type="password" name="webmail_password" /></td></tr>
                        <tr><td></td><td>Specify a password for the above account.</td></tr>
                    </table>
                    <input type="hidden" name="return" value="1" />
                    <input type="submit" name="submit" value="Submit" />
                </form>
            </div>
        </div>
    </body>
</html>
<?PHP
    if(count($_POST) > 0) {
    $nhindconfigsql = '
    USE [master]
GO

/****** Object:  Database [nhindconfig]    Script Date: 08/01/2012 05:06:13 ******/
CREATE DATABASE [nhindconfig] ON  PRIMARY 
( NAME = N\'nhindconfig\', FILENAME = N\'' . $db_data_location . 'nhindconfig.mdf\' , SIZE = 3072KB , MAXSIZE = UNLIMITED, FILEGROWTH = 1024KB )
 LOG ON 
( NAME = N\'nhindconfig_log\', FILENAME = N\'' .$db_logs_location . 'nhindconfig_log.ldf\' , SIZE = 1024KB , MAXSIZE = 2048GB , FILEGROWTH = 10%)
GO

ALTER DATABASE [nhindconfig] SET COMPATIBILITY_LEVEL = 100
GO

IF (1 = FULLTEXTSERVICEPROPERTY(\'IsFullTextInstalled\'))
begin
EXEC [nhindconfig].[dbo].[sp_fulltext_database] @action = \'enable\'
end
GO

ALTER DATABASE [nhindconfig] SET ANSI_NULL_DEFAULT OFF 
GO

ALTER DATABASE [nhindconfig] SET ANSI_NULLS OFF 
GO

ALTER DATABASE [nhindconfig] SET ANSI_PADDING OFF 
GO

ALTER DATABASE [nhindconfig] SET ANSI_WARNINGS OFF 
GO

ALTER DATABASE [nhindconfig] SET ARITHABORT OFF 
GO

ALTER DATABASE [nhindconfig] SET AUTO_CLOSE OFF 
GO

ALTER DATABASE [nhindconfig] SET AUTO_CREATE_STATISTICS ON 
GO

ALTER DATABASE [nhindconfig] SET AUTO_SHRINK OFF 
GO

ALTER DATABASE [nhindconfig] SET AUTO_UPDATE_STATISTICS ON 
GO

ALTER DATABASE [nhindconfig] SET CURSOR_CLOSE_ON_COMMIT OFF 
GO

ALTER DATABASE [nhindconfig] SET CURSOR_DEFAULT  GLOBAL 
GO

ALTER DATABASE [nhindconfig] SET CONCAT_NULL_YIELDS_NULL OFF 
GO

ALTER DATABASE [nhindconfig] SET NUMERIC_ROUNDABORT OFF 
GO

ALTER DATABASE [nhindconfig] SET QUOTED_IDENTIFIER OFF 
GO

ALTER DATABASE [nhindconfig] SET RECURSIVE_TRIGGERS OFF 
GO

ALTER DATABASE [nhindconfig] SET  DISABLE_BROKER 
GO

ALTER DATABASE [nhindconfig] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
GO

ALTER DATABASE [nhindconfig] SET DATE_CORRELATION_OPTIMIZATION OFF 
GO

ALTER DATABASE [nhindconfig] SET TRUSTWORTHY OFF 
GO

ALTER DATABASE [nhindconfig] SET ALLOW_SNAPSHOT_ISOLATION OFF 
GO

ALTER DATABASE [nhindconfig] SET PARAMETERIZATION SIMPLE 
GO

ALTER DATABASE [nhindconfig] SET READ_COMMITTED_SNAPSHOT OFF 
GO

ALTER DATABASE [nhindconfig] SET HONOR_BROKER_PRIORITY OFF 
GO

ALTER DATABASE [nhindconfig] SET  READ_WRITE 
GO

ALTER DATABASE [nhindconfig] SET RECOVERY FULL 
GO

ALTER DATABASE [nhindconfig] SET  MULTI_USER 
GO

ALTER DATABASE [nhindconfig] SET PAGE_VERIFY NONE  
GO

ALTER DATABASE [nhindconfig] SET DB_CHAINING OFF 
GO';
    file_put_contents("nhindconfig.sql",$nhindconfigsql);
    $dpiisql = 'USE [master]
GO

/****** Object:  Database [direct]    Script Date: 06/15/2012 04:06:22 ******/
CREATE DATABASE [direct] ON  PRIMARY 
( NAME = N\'direct\', FILENAME = N\'' . $db_data_location . 'direct.mdf\' , SIZE = 4096KB , MAXSIZE = UNLIMITED, FILEGROWTH = 1024KB )
 LOG ON 
( NAME = N\'direct_log\', FILENAME = N\'' . $db_logs_location . 'direct_log.ldf\' , SIZE = 4224KB , MAXSIZE = 2048GB , FILEGROWTH = 10%)
GO
GO

ALTER DATABASE [direct] SET COMPATIBILITY_LEVEL = 100
GO

IF (1 = FULLTEXTSERVICEPROPERTY(\'IsFullTextInstalled\'))
begin
EXEC [direct].[dbo].[sp_fulltext_database] @action = \'enable\'
end
GO

ALTER DATABASE [direct] SET ANSI_NULL_DEFAULT OFF 
GO

ALTER DATABASE [direct] SET ANSI_NULLS OFF 
GO

ALTER DATABASE [direct] SET ANSI_PADDING OFF 
GO

ALTER DATABASE [direct] SET ANSI_WARNINGS OFF 
GO

ALTER DATABASE [direct] SET ARITHABORT OFF 
GO

ALTER DATABASE [direct] SET AUTO_CLOSE OFF 
GO

ALTER DATABASE [direct] SET AUTO_CREATE_STATISTICS ON 
GO

ALTER DATABASE [direct] SET AUTO_SHRINK OFF 
GO

ALTER DATABASE [direct] SET AUTO_UPDATE_STATISTICS ON 
GO

ALTER DATABASE [direct] SET CURSOR_CLOSE_ON_COMMIT OFF 
GO

ALTER DATABASE [direct] SET CURSOR_DEFAULT  GLOBAL 
GO

ALTER DATABASE [direct] SET CONCAT_NULL_YIELDS_NULL OFF 
GO

ALTER DATABASE [direct] SET NUMERIC_ROUNDABORT OFF 
GO

ALTER DATABASE [direct] SET QUOTED_IDENTIFIER OFF 
GO

ALTER DATABASE [direct] SET RECURSIVE_TRIGGERS OFF 
GO

ALTER DATABASE [direct] SET  DISABLE_BROKER 
GO

ALTER DATABASE [direct] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
GO

ALTER DATABASE [direct] SET DATE_CORRELATION_OPTIMIZATION OFF 
GO

ALTER DATABASE [direct] SET TRUSTWORTHY OFF 
GO

ALTER DATABASE [direct] SET ALLOW_SNAPSHOT_ISOLATION OFF 
GO

ALTER DATABASE [direct] SET PARAMETERIZATION SIMPLE 
GO

ALTER DATABASE [direct] SET READ_COMMITTED_SNAPSHOT OFF 
GO

ALTER DATABASE [direct] SET HONOR_BROKER_PRIORITY OFF 
GO

ALTER DATABASE [direct] SET  READ_WRITE 
GO

ALTER DATABASE [direct] SET RECOVERY FULL 
GO

ALTER DATABASE [direct] SET  MULTI_USER 
GO

ALTER DATABASE [direct] SET PAGE_VERIFY CHECKSUM  
GO

ALTER DATABASE [direct] SET DB_CHAINING OFF 
GO

USE [direct]
GO
/****** Object:  Table [dbo].[users]    Script Date: 06/15/2012 04:22:22 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[users](
	[user_id] [bigint] IDENTITY(1,1) NOT NULL,
	[user_edipi] [bigint] NOT NULL,
	[user_name] [nvarchar](50) NOT NULL,
	[user_mail] [nvarchar](50) NULL,
	[user_theme] [bigint] NOT NULL,
	[user_ep] [nvarchar](max) NOT NULL,
	[user_created_by] [bigint] NOT NULL,
	[user_created_date] [bigint] NOT NULL,
	[user_ext_notify_flag] [tinyint] NOT NULL,
	[user_ext_group_notify_flag] [tinyint] NOT NULL,
	[user_deleted_flag] [tinyint] NOT NULL,
	[user_locale] [nvarchar](max) NULL,
	[user_is_group] [tinyint] NOT NULL,
 CONSTRAINT [PK_users2] PRIMARY KEY CLUSTERED 
(
	[user_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET IDENTITY_INSERT [dbo].[users] ON
INSERT [dbo].[users] ([user_id], [user_edipi], [user_name], [user_mail], [user_theme], [user_ep], [user_created_by], [user_created_date], [user_ext_notify_flag], [user_ext_group_notify_flag], [user_deleted_flag],[user_is_group]) VALUES (1, 0, N\'' . $webmail_user . '\', N\'\', 1, N\'' . $ep .'\', 0, 0, 0, 0, 0, 0)
SET IDENTITY_INSERT [dbo].[users] OFF
/****** Object:  Table [dbo].[themes]    Script Date: 06/15/2012 04:22:22 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[themes](

	[theme_id] [bigint] IDENTITY(1,1) NOT NULL,

	[theme_css_name] [nvarchar](50) NOT NULL,

	[theme_display_name] [text] NOT NULL,

	[theme_preview_bg] [nvarchar](max) NOT NULL,

	[theme_banner_img] [nvarchar](max) NOT NULL,

	[theme_banner_alt_text] [nvarchar](max) NOT NULL,

	[theme_is_default] [tinyint] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET IDENTITY_INSERT [dbo].[themes] ON
INSERT [dbo].[themes] ([theme_id], [theme_css_name], [theme_display_name], [theme_preview_bg], [theme_banner_img], [theme_banner_alt_text], [theme_is_default]) VALUES (1, N\'direct\', N\'DoD Direct Project\', N\'#01243B\', N\'banner.png\', N\'DOD Direct - Simple, Secure Health Messaging\', 1)
SET IDENTITY_INSERT [dbo].[themes] OFF
/****** Object:  Table [dbo].[sessions]    Script Date: 06/15/2012 04:22:22 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[sessions](
	[session_id] [varchar](50) NOT NULL,
	[ip_address] [varchar](50) NOT NULL,
	[user_agent] [varchar](max) NOT NULL,
	[last_activity] [int] NOT NULL,
	[user_data] [text] NULL,
 CONSTRAINT [PK_sessions] PRIMARY KEY CLUSTERED 
(
	[session_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[mail_log]    Script Date: 06/15/2012 04:22:22 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[mail_log](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[time] [bigint] NULL,
	[size] [bigint] NULL,
	[sender] [varchar](max) NULL,
	[recipient] [varchar](max) NULL,
	[attachment_types] [nvarchar](max) NULL,
	[success] [tinyint] NOT NULL,
	[inbound_outbound] [tinyint] NOT NULL,
 CONSTRAINT [PK_mail_log] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[requests]    Script Date: 06/15/2012 04:22:22 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[requests](
	[request_id] [bigint] IDENTITY(1,1) NOT NULL,
	[user_name] [nvarchar](max) NOT NULL,
	[user_edipi] [bigint] NOT NULL,
	[request_date] [bigint] NOT NULL,
	[first_name] [varchar](max) NULL,
	[middle_name] [varchar](max) NULL,
	[last_name] [varchar](max) NULL,
	[organization] [nvarchar](max) NULL,
	[department] [nvarchar](max) NULL,
	[telephone] [nvarchar](50) NULL,
	[mail] [nvarchar](max) NOT NULL,
	[title] [nvarchar](max) NULL,
	[approved_flag] [tinyint] NOT NULL,
	[created_flag] [tinyint] NOT NULL,
	[denied_flag] [tinyint] NOT NULL,
 CONSTRAINT [PK_requests] PRIMARY KEY CLUSTERED 
(
	[request_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[logins]    Script Date: 06/15/2012 04:22:22 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[logins](
	[id] [bigint] IDENTITY(1,1) NOT NULL,
	[session_id] [nvarchar](50) NULL,
	[username] [varchar](50) NULL,
	[ip_address] [nvarchar](50) NULL,
	[login_time] [bigint] NULL,
	[success] [tinyint] NOT NULL,
	[error_msg] [nvarchar](max) NULL,
 CONSTRAINT [PK_logins] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[feedback]    Script Date: 06/15/2012 04:22:22 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[feedback](
	[feedback_id] [bigint] IDENTITY(1,1) NOT NULL,
	[user_id] [bigint] NOT NULL,
	[feedback_type] [nvarchar](50) NOT NULL,
	[feedback_comments] [text] NULL,
	[feedback_datetime] [bigint] NOT NULL,
 CONSTRAINT [PK_feedback] PRIMARY KEY CLUSTERED 
(
	[feedback_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[edit_log]    Script Date: 06/15/2012 04:22:22 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[edit_log](
	[edit_id] [bigint] IDENTITY(1,1) NOT NULL,
	[target_user_id] [bigint] NOT NULL,
	[actor_user_id] [bigint] NOT NULL,
	[edit_action] [text] NOT NULL,
	[edit_datetime] [bigint] NOT NULL,
 CONSTRAINT [PK_edit_log] PRIMARY KEY CLUSTERED 
(
	[edit_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[contacts]    Script Date: 06/15/2012 04:22:22 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[contacts](
	[contact_id] [bigint] IDENTITY(1,1) NOT NULL,
	[user_id] [bigint] NOT NULL,
	[first_name] [varchar](max) NOT NULL,
	[middle_name] [varchar](max) NULL,
	[last_name] [varchar](max) NULL,
	[organization] [nvarchar](max) NULL,
	[department] [nvarchar](max) NULL,
	[telephone] [nvarchar](50) NULL,
	[mail] [nvarchar](50) NOT NULL,
	[title] [nvarchar](max) NULL,
 CONSTRAINT [PK_contacts] PRIMARY KEY CLUSTERED 
(
	[contact_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO';
    file_put_contents("direct.sql",$dpiisql);
    
    $constantsphp = '<?php  if ( ! defined(\'BASEPATH\')) exit(\'No direct script access allowed\');

/*
|--------------------------------------------------------------------------
| File and Directory Modes
|--------------------------------------------------------------------------
|
| These prefs are used when checking and setting modes when working
| with the file system.  The defaults are fine on servers with proper
| security, but you may wish (or even need) to change the values in
| certain environments (Apache running a separate process for each
| user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
| always be used to set the mode correctly.
|
*/
define(\'FILE_READ_MODE\', 0644);
define(\'FILE_WRITE_MODE\', 0666);
define(\'DIR_READ_MODE\', 0755);
define(\'DIR_WRITE_MODE\', 0777);

/*
|--------------------------------------------------------------------------
| File Stream Modes
|--------------------------------------------------------------------------
|
| These modes are used when working with fopen()/popen()
|
*/

define(\'FOPEN_READ\',							\'rb\');
define(\'FOPEN_READ_WRITE\',						\'r+b\');
define(\'FOPEN_WRITE_CREATE_DESTRUCTIVE\',		\'wb\'); // truncates existing file data, use with care
define(\'FOPEN_READ_WRITE_CREATE_DESTRUCTIVE\',	\'w+b\'); // truncates existing file data, use with care
define(\'FOPEN_WRITE_CREATE\',					\'ab\');
define(\'FOPEN_READ_WRITE_CREATE\',				\'a+b\');
define(\'FOPEN_WRITE_CREATE_STRICT\',				\'xb\');
define(\'FOPEN_READ_WRITE_CREATE_STRICT\',		\'x+b\');

/*
|--------------------------------------------------------------------------
| Application Settings
|--------------------------------------------------------------------------
*/

define(\'APPLICATION_BUILD_VERSION\',\'1.1.2\');
define(\'PORTAL_TITLE_PREFIX\', \'DoD Direct Project - \');
define(\'INBOX_DISPLAY_PER_PAGE\', \'25\');
define(\'ADMINPANEL_DISPLAY_PER_PAGE\', \'10\');
define(\'ADMINPANEL_LOG_DISPLAY_PER_PAGE\', \'50\');
define(\'SESSION_TIMEOUT_MINS\', \'10\');
define(\'CUSTOM_MAILBOX_PREFIX\', \'[Custom].\');
define(\'GROUP_MAILBOX_PREFIX\', \'Public\');
define(\'DOD_WARNING_TEXT\',
\'<h2>DOD NOTICE AND CONSENT BANNER</h2>
<p>You are accessing a U.S. Government (USG) Information System (IS) that
is provided for USG-authorized use only.
By using this IS (which includes any device attached to this IS), you consent to the following conditions:
	<ul>
		<li>The USG routinely intercepts and monitors communications on this IS for purposes including, but not limited to, penetration testing, COMSEC monitoring, network operations and defense, personnel misconduct (PM), law enforcement (LE), and counterintelligence (CI) investigations.</li>
		<li>At any time, the USG may inspect and seize data stored on this IS.</li>
		<li>Communications using, or data stored on, this IS are not private, are subject to routine monitoring, interception, and search, and may be disclosed or used for any USG- authorized purpose.</li>
		<li>This IS includes security measures (e.g., authentication and access controls) to protect USG interests--not for your personal benefit or privacy.</li>       
		<li>Notwithstanding the above, using this IS does not constitute consent to PM, LE or CI investigative searching or monitoring of the content of privileged communications, or work product, related to personal representation or services by attorneys, psychotherapists, or clergy,
and their assistants. Such communications and work product are private and confidential. See User Agreement for details.</li>
	</ul></p>\');
	
define(\'MAX_ATTACHMENTS_SIZE\', \'10\'); //given in megabytes

/*
|--------------------------------------------------------------------------
| Application Security Settings
|--------------------------------------------------------------------------
*/
define(\'USE_CAC_AUTH\', \'FALSE\');
define(\'MAX_LOGIN_ATTEMPTS\', \'7\');
define(\'IS_AJAX\', isset($_SERVER[\'HTTP_X_REQUESTED_WITH\']) && strtolower($_SERVER[\'HTTP_X_REQUESTED_WITH\']) == \'xmlhttprequest\');

/*
|--------------------------------------------------------------------------
| Environment Settings
|--------------------------------------------------------------------------
*/

define(\'DP_ENVIRONMENT\', \'PROD\');	

switch(DP_ENVIRONMENT) {

	case \'DEV\':
		// DEVELOPMENT (dev)
		define(\'ENVIRONMENT_TIMEZONE\',\'America/New_York\');
		define(\'IMAP_HOSTNAME\', \'\');
		define(\'IMAP_PORT\', \'\');
		define(\'IMAP_SERVICEFLAGS\', \'\');
		define(\'SMTP_HOSTNAME\', \'\');
		define(\'SMTP_PORT\', \'\');
		define(\'SMTP_TIMEOUT\', \'1\');
		define(\'DIRECT_DOMAIN\', \'\');
		define(\'DIRECT_USERAGENT\', \'\');
		define(\'DIRECT_SEND_PROTOCOL\', \'smtp\');
		define(\'LDAP_HOSTNAME\', \'\');
		define(\'LDAP_PORT\', \'\');
		define(\'LDAP_SEARCH_DOMAIN\', \'\');
		define(\'LDAP_ADMIN_GROUP1\', \'\');
		define(\'LDAP_SEARCH_USERNAME\', \'\');
		define(\'LDAP_SEARCH_PASSWORD\', \'\');
		define(\'LDAP_ACCOUNTS_DN\',\'\');
		define(\'LDAP_GROUPS_DN\',\'\');
		define(\'LDAP_DELETED_ACCOUNTS_DN\',\'\');
		define(\'DATABASE_HOSTNAME\', \'\');
		define(\'DATABASE_NAME\', \'direct\');
		define(\'DATABASE_USERNAME\', \'\');
		define(\'DATABASE_PASSWORD\', \'\');
		define(\'DATABASE_DRIVER\', \'sqlsrv\');
		break;
	
	case \'PROD\':
		// PRODUCTION (prod)
		define(\'ENVIRONMENT_TIMEZONE\',\'America/Denver\');
		define(\'IMAP_HOSTNAME\', \'' . $imap_host . '\');
		define(\'IMAP_PORT\', \'' . $imap_port . '\');
		define(\'IMAP_SERVICEFLAGS\', \'/novalidate-cert\');
		define(\'SMTP_HOSTNAME\', \'' . $smtp_host . '\');
		define(\'SMTP_PORT\', \'' . $smtp_port . '\');
		define(\'SMTP_TIMEOUT\', \'1\');
		define(\'DIRECT_DOMAIN\', \''. $domain . '\');
		define(\'DIRECT_USERAGENT\', \'\');
		define(\'DIRECT_SEND_PROTOCOL\', \'smtp\');
		define(\'LDAP_HOSTNAME\', \'' . $ldap_host . '\');
		define(\'LDAP_PORT\', \'' .$ldap_port . '\');
		define(\'LDAP_SEARCH_DOMAIN\', \'' . $ldap_base_domain . '\');
		define(\'LDAP_ADMIN_GROUP1\', \'ou=admins,' . $ldap_base_domain . '\');
		define(\'LDAP_SEARCH_USERNAME\', \'' .$ldap_search_user . '\');
		define(\'LDAP_SEARCH_PASSWORD\', \'' . $ldap_search_password .'\');
		define(\'LDAP_ACCOUNTS_DN\',\'ou=accounts,' . $ldap_base_domain . '\');
		define(\'LDAP_GROUPS_DN\',\'ou=groups,'.$ldap_base_domain.'\');
		define(\'LDAP_DELETED_ACCOUNTS_DN\',\'ou=deletedaccounts,' . $ldap_base_domain . '\');
		define(\'LDAP_DELETED_GROUPS_DN\',\'ou=deletedgroups,' . $ldap_base_domain . '\');
		define(\'DATABASE_HOSTNAME\', \'' . $db_fqdn . '\\' . $db_instance . ',' . $db_port.'\');
		define(\'DATABASE_NAME\', \'direct\');
		define(\'DATABASE_USERNAME\', \'' . $db_user . '\');
		define(\'DATABASE_PASSWORD\', \'' . $db_password . '\');
		define(\'DATABASE_DRIVER\', \'sqlsrv\');
		break;

}

/* End of file constants.php */
/* Location: ./application/config/constants.php */';
    file_put_contents("constants.php",$constantsphp);
    
    $configphp = '<?php  if ( ! defined(\'BASEPATH\')) exit(\'No direct script access allowed\');

/*
|--------------------------------------------------------------------------
| Base Site URL
|--------------------------------------------------------------------------
|
| URL to your CodeIgniter root. Typically this will be your base URL,
| WITH a trailing slash:
|
|	http://example.com/
|
| If this is not set then CodeIgniter will guess the protocol, domain and
| path to your installation.
|
*/
$config[\'base_url\']	= \'https://' . $domain . '/\';

/*
|--------------------------------------------------------------------------
| Index File
|--------------------------------------------------------------------------
|
| Typically this will be your index.php file, unless you\'ve renamed it to
| something else. If you are using mod_rewrite to remove the page set this
| variable so that it is blank.
|
*/
$config[\'index_page\'] = \'\';

/*
|--------------------------------------------------------------------------
| URI PROTOCOL
|--------------------------------------------------------------------------
|
| This item determines which server global should be used to retrieve the
| URI string.  The default setting of \'AUTO\' works for most servers.
| If your links do not seem to work, try one of the other delicious flavors:
|
| \'AUTO\'			Default - auto detects
| \'PATH_INFO\'		Uses the PATH_INFO
| \'QUERY_STRING\'	Uses the QUERY_STRING
| \'REQUEST_URI\'		Uses the REQUEST_URI
| \'ORIG_PATH_INFO\'	Uses the ORIG_PATH_INFO
|
*/
$config[\'uri_protocol\']	= \'AUTO\';

/*
|--------------------------------------------------------------------------
| URL suffix
|--------------------------------------------------------------------------
|
| This option allows you to add a suffix to all URLs generated by CodeIgniter.
| For more information please see the user guide:
|
| http://codeigniter.com/user_guide/general/urls.html
*/

$config[\'url_suffix\'] = \'\';

/*
|--------------------------------------------------------------------------
| Default Language
|--------------------------------------------------------------------------
|
| This determines which set of language files should be used. Make sure
| there is an available translation if you intend to use something other
| than english.
|
*/
$config[\'language\']	= \'english\';

/*
|--------------------------------------------------------------------------
| Default Character Set
|--------------------------------------------------------------------------
|
| This determines which character set is used by default in various methods
| that require a character set to be provided.
|
*/
$config[\'charset\'] = \'UTF-8\';

/*
|--------------------------------------------------------------------------
| Enable/Disable System Hooks
|--------------------------------------------------------------------------
|
| If you would like to use the \'hooks\' feature you must enable it by
| setting this variable to TRUE (boolean).  See the user guide for details.
|
*/
$config[\'enable_hooks\'] = FALSE;


/*
|--------------------------------------------------------------------------
| Class Extension Prefix
|--------------------------------------------------------------------------
|
| This item allows you to set the filename/classname prefix when extending
| native libraries.  For more information please see the user guide:
|
| http://codeigniter.com/user_guide/general/core_classes.html
| http://codeigniter.com/user_guide/general/creating_libraries.html
|
*/
$config[\'subclass_prefix\'] = \'MY_\';


/*
|--------------------------------------------------------------------------
| Allowed URL Characters
|--------------------------------------------------------------------------
|
| This lets you specify with a regular expression which characters are permitted
| within your URLs.  When someone tries to submit a URL with disallowed
| characters they will get a warning message.
|
| As a security measure you are STRONGLY encouraged to restrict URLs to
| as few characters as possible.  By default only these are allowed: a-z 0-9~%.:_-
|
| Leave blank to allow all characters -- but only if you are insane.
|
| DO NOT CHANGE THIS UNLESS YOU FULLY UNDERSTAND THE REPERCUSSIONS!!
|
*/
$config[\'permitted_uri_chars\'] = \'a-z 0-9~%.:_\-()\';


/*
|--------------------------------------------------------------------------
| Enable Query Strings
|--------------------------------------------------------------------------
|
| By default CodeIgniter uses search-engine friendly segment based URLs:
| example.com/who/what/where/
|
| By default CodeIgniter enables access to the $_GET array.  If for some
| reason you would like to disable it, set \'allow_get_array\' to FALSE.
|
| You can optionally enable standard query string based URLs:
| example.com?who=me&what=something&where=here
|
| Options are: TRUE or FALSE (boolean)
|
| The other items let you set the query string \'words\' that will
| invoke your controllers and its functions:
| example.com/index.php?c=controller&m=function
|
| Please note that some of the helpers won\'t work as expected when
| this feature is enabled, since CodeIgniter is designed primarily to
| use segment based URLs.
|
*/
$config[\'allow_get_array\']		= TRUE;
$config[\'enable_query_strings\'] = FALSE;
$config[\'controller_trigger\']	= \'c\';
$config[\'function_trigger\']		= \'m\';
$config[\'directory_trigger\']	= \'d\'; // experimental not currently in use

/*
|--------------------------------------------------------------------------
| Error Logging Threshold
|--------------------------------------------------------------------------
|
| If you have enabled error logging, you can set an error threshold to
| determine what gets logged. Threshold options are:
| You can enable error logging by setting a threshold over zero. The
| threshold determines what gets logged. Threshold options are:
|
|	0 = Disables logging, Error logging TURNED OFF
|	1 = Error Messages (including PHP errors)
|	2 = Debug Messages
|	3 = Informational Messages
|	4 = All Messages
|
| For a live site you\'ll usually only enable Errors (1) to be logged otherwise
| your log files will fill up very fast.
|
*/
$config[\'log_threshold\'] = 0;

/*
|--------------------------------------------------------------------------
| Error Logging Directory Path
|--------------------------------------------------------------------------
|
| Leave this BLANK unless you would like to set something other than the default
| application/logs/ folder. Use a full server path with trailing slash.
|
*/
$config[\'log_path\'] = \'\';

/*
|--------------------------------------------------------------------------
| Date Format for Logs
|--------------------------------------------------------------------------
|
| Each item that is logged has an associated date. You can use PHP date
| codes to set your own date formatting
|
*/
$config[\'log_date_format\'] = \'Y-m-d H:i:s\';

/*
|--------------------------------------------------------------------------
| Cache Directory Path
|--------------------------------------------------------------------------
|
| Leave this BLANK unless you would like to set something other than the default
| system/cache/ folder.  Use a full server path with trailing slash.
|
*/
$config[\'cache_path\'] = \'\';

/*
|--------------------------------------------------------------------------
| Encryption Key
|--------------------------------------------------------------------------
|
| If you use the Encryption class or the Session class you
| MUST set an encryption key.  See the user guide for info.
|
*/
$config[\'encryption_key\'] = \'' . $key . '\';

/*
|--------------------------------------------------------------------------
| Session Variables
|--------------------------------------------------------------------------
|
| \'sess_cookie_name\'		= the name you want for the cookie
| \'sess_expiration\'			= the number of SECONDS you want the session to last.
|   by default sessions last 7200 seconds (two hours).  Set to zero for no expiration.
| \'sess_expire_on_close\'	= Whether to cause the session to expire automatically
|   when the browser window is closed
| \'sess_encrypt_cookie\'		= Whether to encrypt the cookie
| \'sess_use_database\'		= Whether to save the session data to a database
| \'sess_table_name\'			= The name of the session database table
| \'sess_match_ip\'			= Whether to match the user\'s IP address when reading the session data
| \'sess_match_useragent\'	= Whether to match the User Agent when reading the session data
| \'sess_time_to_update\'		= how many seconds between CI refreshing Session Information
|
*/
$config[\'sess_cookie_name\']		= \'direct_session\';
$config[\'sess_expiration\']		= 7200;
$config[\'sess_expire_on_close\']	= TRUE;
$config[\'sess_encrypt_cookie\']	= TRUE;
$config[\'sess_use_database\']	= TRUE;
$config[\'sess_table_name\']		= \'sessions\';
$config[\'sess_match_ip\']		= FALSE;
$config[\'sess_match_useragent\']	= TRUE;
$config[\'sess_time_to_update\']	= 300;


/*
|--------------------------------------------------------------------------
| Cookie Related Variables
|--------------------------------------------------------------------------
|
| \'cookie_prefix\' = Set a prefix if you need to avoid collisions
| \'cookie_domain\' = Set to .your-domain.com for site-wide cookies
| \'cookie_path\'   =  Typically will be a forward slash
| \'cookie_secure\' =  Cookies will only be set if a secure HTTPS connection exists.
|
*/
$config[\'cookie_prefix\']	= "";
$config[\'cookie_domain\']	= "";
$config[\'cookie_path\']		= "/";
$config[\'cookie_secure\'] = TRUE;
$config[\'cookie_httponly\'] = TRUE;

/*
|--------------------------------------------------------------------------
| Global XSS Filtering
|--------------------------------------------------------------------------
|
| Determines whether the XSS filter is always active when GET, POST or
| COOKIE data is encountered
|
*/
$config[\'global_xss_filtering\'] = FALSE;

/*
|--------------------------------------------------------------------------
| Cross Site Request Forgery
|--------------------------------------------------------------------------
| Enables a CSRF cookie token to be set. When set to TRUE, token will be
| checked on a submitted form. If you are accepting user data, it is strongly
| recommended CSRF protection be enabled.
|
| \'csrf_token_name\' = The token name
| \'csrf_cookie_name\' = The cookie name
| \'csrf_expire\' = The number in seconds the token should expire.
*/
$config[\'csrf_protection\'] = FALSE;
$config[\'csrf_token_name\'] = \'csrf_test_name\';
$config[\'csrf_cookie_name\'] = \'csrf_cookie_name\';
$config[\'csrf_expire\'] = 7200;

/*
|--------------------------------------------------------------------------
| Output Compression
|--------------------------------------------------------------------------
|
| Enables Gzip output compression for faster page loads.  When enabled,
| the output class will test whether your server supports Gzip.
| Even if it does, however, not all browsers support compression
| so enable only if you are reasonably sure your visitors can handle it.
|
| VERY IMPORTANT:  If you are getting a blank page when compression is enabled it
| means you are prematurely outputting something to your browser. It could
| even be a line of whitespace at the end of one of your scripts.  For
| compression to work, nothing can be sent before the output buffer is called
| by the output class.  Do not \'echo\' any values with compression enabled.
|
*/
$config[\'compress_output\'] = FALSE;

/*
|--------------------------------------------------------------------------
| Master Time Reference
|--------------------------------------------------------------------------
|
| Options are \'local\' or \'gmt\'.  This pref tells the system whether to use
| your server\'s local time as the master \'now\' reference, or convert it to
| GMT.  See the \'date helper\' page of the user guide for information
| regarding date handling.
|
*/
$config[\'time_reference\'] = \'local\';


/*
|--------------------------------------------------------------------------
| Rewrite PHP Short Tags
|--------------------------------------------------------------------------
|
| If your PHP installation does not have short tag support enabled CI
| can rewrite the tags on-the-fly, enabling you to utilize that syntax
| in your view files.  Options are TRUE or FALSE (boolean)
|
*/
$config[\'rewrite_short_tags\'] = FALSE;


/*
|--------------------------------------------------------------------------
| Reverse Proxy IPs
|--------------------------------------------------------------------------
|
| If your server is behind a reverse proxy, you must whitelist the proxy IP
| addresses from which CodeIgniter should trust the HTTP_X_FORWARDED_FOR
| header in order to properly identify the visitor\'s IP address.
| Comma-delimited, e.g. \'10.0.1.200,10.0.1.201\'
|
*/
$config[\'proxy_ips\'] = \'\';



/* End of file config.php */
/* Location: ./application/config/config.php */
';

file_put_contents("config.php",$configphp);
    
    $httpdconf = '
#
# This is the main Apache HTTP server configuration file.  It contains the
# configuration directives that give the server its instructions.
# See <URL:http://httpd.apache.org/docs/2.2> for detailed information.
# In particular, see 
# <URL:http://httpd.apache.org/docs/2.2/mod/directives.html>
# for a discussion of each configuration directive.
#
# Do NOT simply read the instructions in here without understanding
# what they do.  They\'re here only as hints or reminders.  If you are unsure
# consult the online docs. You have been warned.  
#
# Configuration and logfile names: If the filenames you specify for many
# of the server\'s control files begin with "/" (or "drive:/" for Win32), the
# server will use that explicit path.  If the filenames do *not* begin
# with "/", the value of ServerRoot is prepended -- so "logs/foo.log"
# with ServerRoot set to "' . $apache_location . '" will be interpreted by the
# server as "' . $apache_location . '/logs/foo.log".
#
# NOTE: Where filenames are specified, you must use forward slashes
# instead of backslashes (e.g., "c:/apache" instead of "c:\apache").
# If a drive letter is omitted, the drive on which httpd.exe is located
# will be used by default.  It is recommended that you always supply
# an explicit drive letter in absolute paths to avoid confusion.

#
# ServerRoot: The top of the directory tree under which the server\'s
# configuration, error, and log files are kept.
#
# Do not add a slash at the end of the directory path.  If you point
# ServerRoot at a non-local disk, be sure to point the LockFile directive
# at a local disk.  If you wish to share the same ServerRoot for multiple
# httpd daemons, you will need to change at least LockFile and PidFile.
#
ServerRoot "' . $apache_location . '"
PidFile "' . $apache_location . '/logs/pid"
ScoreBoardFile "' . $apache_location . '/logs/scoreboard"

#
# Listen: Allows you to bind Apache to specific IP addresses and/or
# ports, instead of the default. See also the <VirtualHost>
# directive.
#
# Change this to Listen on specific IP addresses as shown below to 
# prevent Apache from glomming onto all bound IP addresses.
#
#Listen 12.34.56.78:80
Listen '. $apache_ip . ':80

#ServerTokens
ServerTokens Prod

#Keep Alive Timeout
KeepAlive On
KeepAliveTimeout 15
Timeout 300

#Limit Requests
LimitRequestBody 2147483647
LimitRequestFields 32767
LimitRequestFieldsize 8190
LimitRequestLine 8190


#
# Dynamic Shared Object (DSO) Support
#
# To be able to use the functionality of a module which was built as a DSO you
# have to place corresponding \'LoadModule\' lines at this location so the
# directives contained in it are actually available _before_ they are used.
# Statically compiled modules (those listed by \'httpd -l\') do not need
# to be loaded here.
#
# Example:
# LoadModule foo_module modules/mod_foo.so
#
LoadModule actions_module modules/mod_actions.so
LoadModule alias_module modules/mod_alias.so
LoadModule asis_module modules/mod_asis.so
LoadModule auth_basic_module modules/mod_auth_basic.so
#LoadModule auth_digest_module modules/mod_auth_digest.so
#LoadModule authn_alias_module modules/mod_authn_alias.so
#LoadModule authn_anon_module modules/mod_authn_anon.so
#LoadModule authn_dbd_module modules/mod_authn_dbd.so
#LoadModule authn_dbm_module modules/mod_authn_dbm.so
LoadModule authn_default_module modules/mod_authn_default.so
LoadModule authn_file_module modules/mod_authn_file.so
LoadModule authnz_ldap_module modules/mod_authnz_ldap.so
#LoadModule authz_dbm_module modules/mod_authz_dbm.so
LoadModule authz_default_module modules/mod_authz_default.so
LoadModule authz_groupfile_module modules/mod_authz_groupfile.so
LoadModule authz_host_module modules/mod_authz_host.so
#LoadModule authz_owner_module modules/mod_authz_owner.so
LoadModule authz_user_module modules/mod_authz_user.so
#LoadModule autoindex_module modules/mod_autoindex.so
#LoadModule cache_module modules/mod_cache.so
#LoadModule cern_meta_module modules/mod_cern_meta.so
LoadModule cgi_module modules/mod_cgi.so
#LoadModule charset_lite_module modules/mod_charset_lite.so
#LoadModule dav_module modules/mod_dav.so
#LoadModule dav_fs_module modules/mod_dav_fs.so
#LoadModule dav_lock_module modules/mod_dav_lock.so
#LoadModule dbd_module modules/mod_dbd.so
#LoadModule deflate_module modules/mod_deflate.so
LoadModule dir_module modules/mod_dir.so
#LoadModule disk_cache_module modules/mod_disk_cache.so
#LoadModule dumpio_module modules/mod_dumpio.so
LoadModule env_module modules/mod_env.so
#LoadModule expires_module modules/mod_expires.so
#LoadModule ext_filter_module modules/mod_ext_filter.so
#LoadModule file_cache_module modules/mod_file_cache.so
#LoadModule filter_module modules/mod_filter.so
#LoadModule headers_module modules/mod_headers.so
#LoadModule ident_module modules/mod_ident.so
#LoadModule imagemap_module modules/mod_imagemap.so
LoadModule include_module modules/mod_include.so
#LoadModule info_module modules/mod_info.so
LoadModule isapi_module modules/mod_isapi.so
LoadModule ldap_module modules/mod_ldap.so
#LoadModule logio_module modules/mod_logio.so
LoadModule log_config_module modules/mod_log_config.so
#LoadModule log_forensic_module modules/mod_log_forensic.so
#LoadModule mem_cache_module modules/mod_mem_cache.so
LoadModule mime_module modules/mod_mime.so
#LoadModule mime_magic_module modules/mod_mime_magic.so
LoadModule negotiation_module modules/mod_negotiation.so
#LoadModule proxy_module modules/mod_proxy.so
#LoadModule proxy_ajp_module modules/mod_proxy_ajp.so
#LoadModule proxy_balancer_module modules/mod_proxy_balancer.so
#LoadModule proxy_connect_module modules/mod_proxy_connect.so
#LoadModule proxy_ftp_module modules/mod_proxy_ftp.so
#LoadModule proxy_http_module modules/mod_proxy_http.so
#LoadModule proxy_scgi_module modules/mod_proxy_scgi.so
#LoadModule reqtimeout_module modules/mod_reqtimeout.so
LoadModule rewrite_module modules/mod_rewrite.so
LoadModule setenvif_module modules/mod_setenvif.so
#LoadModule speling_module modules/mod_speling.so
LoadModule ssl_module modules/mod_ssl.so
#LoadModule status_module modules/mod_status.so
#LoadModule substitute_module modules/mod_substitute.so
LoadModule unique_id_module modules/mod_unique_id.so
LoadModule security2_module modules/mod_security2/mod_security2.so
#LoadModule userdir_module modules/mod_userdir.so
#LoadModule usertrack_module modules/mod_usertrack.so
#LoadModule version_module modules/mod_version.so
#LoadModule vhost_alias_module modules/mod_vhost_alias.so
LoadModule php5_module "'. $php_location  .'\php5apache2_2.dll"

<IfModule !mpm_netware_module>
<IfModule !mpm_winnt_module>
#
# If you wish httpd to run as a different user or group, you must run
# httpd as root initially and it will switch.  
#
# User/Group: The name (or #number) of the user/group to run httpd as.
# It is usually good practice to create a dedicated user and group for
# running httpd, as with most system services.
#
User daemon
Group daemon

</IfModule>
</IfModule>

# \'Main\' server configuration
#
# The directives in this section set up the values used by the \'main\'
# server, which responds to any requests that aren\'t handled by a
# <VirtualHost> definition.  These values also provide defaults for
# any <VirtualHost> containers you may define later in the file.
#
# All of these directives may appear inside <VirtualHost> containers,
# in which case these default settings will be overridden for the
# virtual host being defined.
#

#
# ServerAdmin: Your address, where problems with the server should be
# e-mailed.  This address appears on some server-generated pages, such
# as error documents.  e.g. admin@your-domain.com
#
ServerAdmin admin@' . $domain . '

#
# ServerName gives the name and port that the server uses to identify itself.
# This can often be determined automatically, but we recommend you specify
# it explicitly to prevent problems during startup.
#
# If your host doesn\'t have a registered DNS name, enter its IP address here.
#
#ServerName ' . $domain . ':80

#
# DocumentRoot: The directory out of which you will serve your
# documents. By default, all requests are taken from this directory, but
# symbolic links and aliases may be used to point to other locations.
#
DocumentRoot "' . $document_root . '"

#
# Each directory to which Apache has access can be configured with respect
# to which services and features are allowed and/or disabled in that
# directory (and its subdirectories). 
#
# First, we configure the "default" to be a very restrictive set of 
# features.  
#
<Directory />
    Options None
    AllowOverride None
    Order deny,allow
    Deny from all
</Directory>

#
# Note that from this point forward you must specifically allow
# particular features to be enabled - so if something\'s not working as
# you might expect, make sure that you have specifically enabled it
# below.
#

#
# This should be changed to whatever you set DocumentRoot to.
#
<Directory "' . $document_root . '">
    #
    # Possible values for the Options directive are "None", "All",
    # or any combination of:
    #   Indexes Includes FollowSymLinks SymLinksIfOwnerMatch ExecCGI MultiViews
    #
    # Note that "MultiViews" must be named *explicitly* --- "Options All"
    # doesn\'t give it to you.
    #
    # The Options directive is both complicated and important.  Please see
    # http://httpd.apache.org/docs/2.2/mod/core.html#options
    # for more information.
    #
    Options +SymLinksIfOwnerMatch -Indexes -FollowSymLinks -Includes -Multiviews

    #
    # AllowOverride controls what directives may be placed in .htaccess files.
    # It can be "All", "None", or any combination of the keywords:
    #   Options FileInfo AuthConfig Limit
    #
    AllowOverride All

    #
    # Controls who can get stuff from this server.
    #
    Order allow,deny
    Allow from all

    <LimitExcept GET POST OPTIONS>
	Deny From all
    </LimitExcept>
</Directory>

#
# DirectoryIndex: sets the file that Apache will serve if a directory
# is requested.
#
<IfModule dir_module>
    DirectoryIndex index.php index.html
</IfModule>

#
# The following lines prevent .htaccess and .htpasswd files from being 
# viewed by Web clients. 
#
<FilesMatch "^\.ht">
    Order allow,deny
    Deny from all
    Satisfy All
</FilesMatch>

#
# ErrorLog: The location of the error log file.
# If you do not specify an ErrorLog directive within a <VirtualHost>
# container, error messages relating to that virtual host will be
# logged here.  If you *do* define an error logfile for a <VirtualHost>
# container, that host\'s errors will be logged there and not here.
#
ErrorLog "logs/error.log"

#
# LogLevel: Control the number of messages logged to the error_log.
# Possible values include: debug, info, notice, warn, error, crit,
# alert, emerg.
#
LogLevel debug

<IfModule log_config_module>
    #
    # The following directives define some format nicknames for use with
    # a CustomLog directive (see below).
    #
    LogFormat "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\"" combined
    LogFormat "%h %l %u %t \"%r\" %>s %b" common

    <IfModule logio_module>
      # You need to enable mod_logio.c to use %I and %O
      LogFormat "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\" %I %O" combinedio
    </IfModule>

    #
    # The location and format of the access logfile (Common Logfile Format).
    # If you do not define any access logfiles within a <VirtualHost>
    # container, they will be logged here.  Contrariwise, if you *do*
    # define per-<VirtualHost> access logfiles, transactions will be
    # logged therein and *not* in this file.
    #
    CustomLog "logs/access.log" common

    #
    # If you prefer a logfile with access, agent, and referer information
    # (Combined Logfile Format) you can use the following directive.
    #
    #CustomLog "logs/access.log" combined
</IfModule>

<IfModule alias_module>
    #
    # Redirect: Allows you to tell clients about documents that used to 
    # exist in your server\'s namespace, but do not anymore. The client 
    # will make a new request for the document at its new location.
    # Example:
    # Redirect permanent /foo http://' . $domain . '/bar

    #
    # Alias: Maps web paths into filesystem paths and is used to
    # access content that does not live under the DocumentRoot.
    # Example:
    # Alias /webpath /full/filesystem/path
    #
    # If you include a trailing / on /webpath then the server will
    # require it to be present in the URL.  You will also likely
    # need to provide a <Directory> section to allow access to
    # the filesystem path.

    #
    # ScriptAlias: This controls which directories contain server scripts. 
    # ScriptAliases are essentially the same as Aliases, except that
    # documents in the target directory are treated as applications and
    # run by the server when requested rather than as documents sent to the
    # client.  The same rules about trailing "/" apply to ScriptAlias
    # directives as to Alias.
    #
    ScriptAlias /cgi-bin/ "' . $apache_location . '/cgi-bin/"

</IfModule>

<IfModule cgid_module>
    #
    # ScriptSock: On threaded servers, designate the path to the UNIX
    # socket used to communicate with the CGI daemon of mod_cgid.
    #
    #Scriptsock logs/cgisock
</IfModule>

#
# "' . $apache_location . '/cgi-bin" should be changed to whatever your ScriptAliased
# CGI directory exists, if you have that configured.
#
<Directory "' . $apache_location . '/cgi-bin">
    AllowOverride None
    Options None
    Order allow,deny
    Allow from all
</Directory>

#
# DefaultType: the default MIME type the server will use for a document
# if it cannot otherwise determine one, such as from filename extensions.
# If your server contains mostly text or HTML documents, "text/plain" is
# a good value.  If most of your content is binary, such as applications
# or images, you may want to use "application/octet-stream" instead to
# keep browsers from trying to display binary files as though they are
# text.
#
DefaultType text/plain

<IfModule mime_module>
    #
    # TypesConfig points to the file containing the list of mappings from
    # filename extension to MIME-type.
    #
    TypesConfig conf/mime.types

    #
    # AddType allows you to add to or override the MIME configuration
    # file specified in TypesConfig for specific file types.
    #
    #AddType application/x-gzip .tgz
    #
    # AddEncoding allows you to have certain browsers uncompress
    # information on the fly. Note: Not all browsers support this.
    #
    #AddEncoding x-compress .Z
    #AddEncoding x-gzip .gz .tgz
    #
    # If the AddEncoding directives above are commented-out, then you
    # probably should define those extensions to indicate media types:
    #
    AddType application/x-compress .Z
    AddType application/x-gzip .gz .tgz
    AddType application/x-httpd-php .php

    #
    # AddHandler allows you to map certain file extensions to "handlers":
    # actions unrelated to filetype. These can be either built into the server
    # or added with the Action directive (see below)
    #
    # To use CGI scripts outside of ScriptAliased directories:
    # (You will also need to add "ExecCGI" to the "Options" directive.)
    #
    #AddHandler cgi-script .cgi

    # For type maps (negotiated resources):
    #AddHandler type-map var
    Options None
    #
    # Filters allow you to process content before it is sent to the client.
    #
    # To parse .shtml files for server-side includes (SSI):
    # (You will also need to add "Includes" to the "Options" directive.)
    #
    #AddType text/html .shtml
    #AddOutputFilter INCLUDES .shtml
</IfModule>

#
# The mod_mime_magic module allows the server to use various hints from the
# contents of the file itself to determine its type.  The MIMEMagicFile
# directive tells the module where the hint definitions are located.
#
#MIMEMagicFile conf/magic

#
# Customizable error responses come in three flavors:
# 1) plain text 2) local redirects 3) external redirects
#
# Some examples:
#ErrorDocument 500 "The server made a boo boo."
#ErrorDocument 404 /missing.html
#ErrorDocument 404 "/cgi-bin/missing_handler.pl"
#ErrorDocument 402 http://' . $domain . '/subscription_info.html
#

#
# MaxRanges: Maximum number of Ranges in a request before
# returning the entire resource, or 0 for unlimited
# Default setting is to accept 200 Ranges
#MaxRanges 0

#
# EnableMMAP and EnableSendfile: On systems that support it, 
# memory-mapping or the sendfile syscall is used to deliver
# files.  This usually improves server performance, but must
# be turned off when serving from networked-mounted 
# filesystems or if support for these functions is otherwise
# broken on your system.
#
#EnableMMAP off
#EnableSendfile off

#Enable or Disable HTTP TRACE
TraceEnable Off

# Supplemental configuration
#
# The configuration files in the conf/extra/ directory can be 
# included to add extra features or to modify the default configuration of 
# the server, or you may simply copy their contents here and change as 
# necessary.

# Server-pool management (MPM specific)
#Include conf/extra/httpd-mpm.conf

# Multi-language error messages
#Include conf/extra/httpd-multilang-errordoc.conf

# Fancy directory listings
#Include conf/extra/httpd-autoindex.conf

# Language settings
#Include conf/extra/httpd-languages.conf

# User home directories
#Include conf/extra/httpd-userdir.conf

# Real-time info on requests and configuration
#Include conf/extra/httpd-info.conf

# Virtual hosts
#Include conf/extra/httpd-vhosts.conf

# Local access to the Apache HTTP Server Manual
#Include conf/extra/httpd-manual.conf

# Distributed authoring and versioning (WebDAV)
#Include conf/extra/httpd-dav.conf

# Various default settings
#Include conf/extra/httpd-default.conf

# Secure (SSL/TLS) connections
#Include conf/extra/httpd-ssl.conf
#
# Note: The following must must be present to support
#       starting without SSL on platforms with no /dev/random equivalent
#       but a statically compiled-in mod_ssl.
#
<IfModule ssl_module>
SSLRandomSeed startup builtin
SSLRandomSeed connect builtin
</IfModule>';

file_put_contents("httpd.conf",$httpdconf);
}

if(isset($ldap_ssl_location) && strlen(trim($ldap_ssl_location)) > 0) {
    $ldapconf = "TLS_REQCERT never\r\nTLC_CACERT " . $ldap_ssl_location . "\r\n";
        file_put_contents("ldap.conf",$ldapconf);
}

?>
<?php
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP 5.1.6 or newer
 *
 * @package		CodeIgniter
 * @author		ExpressionEngine Dev Team
 * @copyright	Copyright (c) 2008 - 2011, EllisLab, Inc.
 * @license		http://codeigniter.com/user_guide/license.html
 * @link		http://codeigniter.com
 * @since		Version 1.0
 * @filesource
 */

// ------------------------------------------------------------------------

/**
 * CodeIgniter Encryption Class
 *
 * Provides two-way keyed encoding using XOR Hashing and Mcrypt
 *
 * @package		CodeIgniter
 * @subpackage	Libraries
 * @category	Libraries
 * @author		ExpressionEngine Dev Team
 * @link		http://codeigniter.com/user_guide/libraries/encryption.html
 */
class CI_Encrypt {

	var $CI;
	var $encryption_key	= '5tG&4S0dal1#jdsal&1jF9;@d!?XrQrPoFe3qalf@fr0cavfjx2dfQ';
	var $_hash_type	= 'sha1';
	var $_mcrypt_exists = FALSE;
	var $_mcrypt_cipher;
	var $_mcrypt_mode;

	/**
	 * Constructor
	 *
	 * Simply determines whether the mcrypt library exists.
	 *
	 */
	public function __construct()
	{
		$this->_mcrypt_exists = ( ! function_exists('mcrypt_encrypt')) ? FALSE : TRUE;
	}

	// --------------------------------------------------------------------

	/**
	 * Fetch the encryption key
	 *
	 * Returns it as MD5 in order to have an exact-length 128 bit key.
	 * Mcrypt is sensitive to keys that are not the correct length
	 *
	 * @access	public
	 * @param	string
	 * @return	string
	 */
	function get_key($key = '')
	{
		if ($key == '')
		{
			if ($this->encryption_key != '')
			{
				return $this->encryption_key;
			}
		}

		return md5($key);
	}

	// --------------------------------------------------------------------

	/**
	 * Set the encryption key
	 *
	 * @access	public
	 * @param	string
	 * @return	void
	 */
	function set_key($key = '')
	{
		$this->encryption_key = $key;
	}

	// --------------------------------------------------------------------

	/**
	 * Encode
	 *
	 * Encodes the message string using bitwise XOR encoding.
	 * The key is combined with a random hash, and then it
	 * too gets converted using XOR. The whole thing is then run
	 * through mcrypt (if supported) using the randomized key.
	 * The end result is a double-encrypted message string
	 * that is randomized with each call to this function,
	 * even if the supplied message and key are the same.
	 *
	 * @access	public
	 * @param	string	the string to encode
	 * @param	string	the key
	 * @return	string
	 */
	function encode($string, $key = '')
	{
		$key = $this->get_key($key);

		if ($this->_mcrypt_exists === TRUE)
		{
			$enc = $this->mcrypt_encode($string, $key);
		}
		else
		{
			$enc = $this->_xor_encode($string, $key);
		}

		return base64_encode($enc);
	}

	// --------------------------------------------------------------------

	/**
	 * Decode
	 *
	 * Reverses the above process
	 *
	 * @access	public
	 * @param	string
	 * @param	string
	 * @return	string
	 */
	function decode($string, $key = '')
	{
		$key = $this->get_key($key);

		if (preg_match('/[^a-zA-Z0-9\/\+=]/', $string))
		{
			return FALSE;
		}

		$dec = base64_decode($string);

		if ($this->_mcrypt_exists === TRUE)
		{
			if (($dec = $this->mcrypt_decode($dec, $key)) === FALSE)
			{
				return FALSE;
			}
		}
		else
		{
			$dec = $this->_xor_decode($dec, $key);
		}

		return $dec;
	}

	// --------------------------------------------------------------------

	/**
	 * Encode from Legacy
	 *
	 * Takes an encoded string from the original Encryption class algorithms and
	 * returns a newly encoded string using the improved method added in 2.0.0
	 * This allows for backwards compatibility and a method to transition to the
	 * new encryption algorithms.
	 *
	 * For more details, see http://codeigniter.com/user_guide/installation/upgrade_200.html#encryption
	 *
	 * @access	public
	 * @param	string
	 * @param	int		(mcrypt mode constant)
	 * @param	string
	 * @return	string
	 */
	function encode_from_legacy($string, $legacy_mode = MCRYPT_MODE_ECB, $key = '')
	{
		if ($this->_mcrypt_exists === FALSE)
		{
			log_message('error', 'Encoding from legacy is available only when Mcrypt is in use.');
			return FALSE;
		}

		// decode it first
		// set mode temporarily to what it was when string was encoded with the legacy
		// algorithm - typically MCRYPT_MODE_ECB
		$current_mode = $this->_get_mode();
		$this->set_mode($legacy_mode);

		$key = $this->get_key($key);

		if (preg_match('/[^a-zA-Z0-9\/\+=]/', $string))
		{
			return FALSE;
		}

		$dec = base64_decode($string);

		if (($dec = $this->mcrypt_decode($dec, $key)) === FALSE)
		{
			return FALSE;
		}

		$dec = $this->_xor_decode($dec, $key);

		// set the mcrypt mode back to what it should be, typically MCRYPT_MODE_CBC
		$this->set_mode($current_mode);

		// and re-encode
		return base64_encode($this->mcrypt_encode($dec, $key));
	}

	// --------------------------------------------------------------------

	/**
	 * XOR Encode
	 *
	 * Takes a plain-text string and key as input and generates an
	 * encoded bit-string using XOR
	 *
	 * @access	private
	 * @param	string
	 * @param	string
	 * @return	string
	 */
	function _xor_encode($string, $key)
	{
		$rand = '';
		while (strlen($rand) < 32)
		{
			$rand .= mt_rand(0, mt_getrandmax());
		}

		$rand = $this->hash($rand);

		$enc = '';
		for ($i = 0; $i < strlen($string); $i++)
		{
			$enc .= substr($rand, ($i % strlen($rand)), 1).(substr($rand, ($i % strlen($rand)), 1) ^ substr($string, $i, 1));
		}

		return $this->_xor_merge($enc, $key);
	}

	// --------------------------------------------------------------------

	/**
	 * XOR Decode
	 *
	 * Takes an encoded string and key as input and generates the
	 * plain-text original message
	 *
	 * @access	private
	 * @param	string
	 * @param	string
	 * @return	string
	 */
	function _xor_decode($string, $key)
	{
		$string = $this->_xor_merge($string, $key);

		$dec = '';
		for ($i = 0; $i < strlen($string); $i++)
		{
			$dec .= (substr($string, $i++, 1) ^ substr($string, $i, 1));
		}

		return $dec;
	}

	// --------------------------------------------------------------------

	/**
	 * XOR key + string Combiner
	 *
	 * Takes a string and key as input and computes the difference using XOR
	 *
	 * @access	private
	 * @param	string
	 * @param	string
	 * @return	string
	 */
	function _xor_merge($string, $key)
	{
		$hash = $this->hash($key);
		$str = '';
		for ($i = 0; $i < strlen($string); $i++)
		{
			$str .= substr($string, $i, 1) ^ substr($hash, ($i % strlen($hash)), 1);
		}

		return $str;
	}

	// --------------------------------------------------------------------

	/**
	 * Encrypt using Mcrypt
	 *
	 * @access	public
	 * @param	string
	 * @param	string
	 * @return	string
	 */
	function mcrypt_encode($data, $key)
	{
		$init_size = mcrypt_get_iv_size($this->_get_cipher(), $this->_get_mode());
		$init_vect = mcrypt_create_iv($init_size, MCRYPT_RAND);
		return $this->_add_cipher_noise($init_vect.mcrypt_encrypt($this->_get_cipher(), $key, $data, $this->_get_mode(), $init_vect), $key);
	}

	// --------------------------------------------------------------------

	/**
	 * Decrypt using Mcrypt
	 *
	 * @access	public
	 * @param	string
	 * @param	string
	 * @return	string
	 */
	function mcrypt_decode($data, $key)
	{
		$data = $this->_remove_cipher_noise($data, $key);
		$init_size = mcrypt_get_iv_size($this->_get_cipher(), $this->_get_mode());

		if ($init_size > strlen($data))
		{
			return FALSE;
		}

		$init_vect = substr($data, 0, $init_size);
		$data = substr($data, $init_size);
		return rtrim(mcrypt_decrypt($this->_get_cipher(), $key, $data, $this->_get_mode(), $init_vect), "\0");
	}

	// --------------------------------------------------------------------

	/**
	 * Adds permuted noise to the IV + encrypted data to protect
	 * against Man-in-the-middle attacks on CBC mode ciphers
	 * http://www.ciphersbyritter.com/GLOSSARY.HTM#IV
	 *
	 * Function description
	 *
	 * @access	private
	 * @param	string
	 * @param	string
	 * @return	string
	 */
	function _add_cipher_noise($data, $key)
	{
		$keyhash = $this->hash($key);
		$keylen = strlen($keyhash);
		$str = '';

		for ($i = 0, $j = 0, $len = strlen($data); $i < $len; ++$i, ++$j)
		{
			if ($j >= $keylen)
			{
				$j = 0;
			}

			$str .= chr((ord($data[$i]) + ord($keyhash[$j])) % 256);
		}

		return $str;
	}

	// --------------------------------------------------------------------

	/**
	 * Removes permuted noise from the IV + encrypted data, reversing
	 * _add_cipher_noise()
	 *
	 * Function description
	 *
	 * @access	public
	 * @param	type
	 * @return	type
	 */
	function _remove_cipher_noise($data, $key)
	{
		$keyhash = $this->hash($key);
		$keylen = strlen($keyhash);
		$str = '';

		for ($i = 0, $j = 0, $len = strlen($data); $i < $len; ++$i, ++$j)
		{
			if ($j >= $keylen)
			{
				$j = 0;
			}

			$temp = ord($data[$i]) - ord($keyhash[$j]);

			if ($temp < 0)
			{
				$temp = $temp + 256;
			}

			$str .= chr($temp);
		}

		return $str;
	}

	// --------------------------------------------------------------------

	/**
	 * Set the Mcrypt Cipher
	 *
	 * @access	public
	 * @param	constant
	 * @return	string
	 */
	function set_cipher($cipher)
	{
		$this->_mcrypt_cipher = $cipher;
	}

	// --------------------------------------------------------------------

	/**
	 * Set the Mcrypt Mode
	 *
	 * @access	public
	 * @param	constant
	 * @return	string
	 */
	function set_mode($mode)
	{
		$this->_mcrypt_mode = $mode;
	}

	// --------------------------------------------------------------------

	/**
	 * Get Mcrypt cipher Value
	 *
	 * @access	private
	 * @return	string
	 */
	function _get_cipher()
	{
		if ($this->_mcrypt_cipher == '')
		{
			$this->_mcrypt_cipher = MCRYPT_RIJNDAEL_256;
		}

		return $this->_mcrypt_cipher;
	}

	// --------------------------------------------------------------------

	/**
	 * Get Mcrypt Mode Value
	 *
	 * @access	private
	 * @return	string
	 */
	function _get_mode()
	{
		if ($this->_mcrypt_mode == '')
		{
			$this->_mcrypt_mode = MCRYPT_MODE_CBC;
		}

		return $this->_mcrypt_mode;
	}

	// --------------------------------------------------------------------

	/**
	 * Set the Hash type
	 *
	 * @access	public
	 * @param	string
	 * @return	string
	 */
	function set_hash($type = 'sha1')
	{
		$this->_hash_type = ($type != 'sha1' AND $type != 'md5') ? 'sha1' : $type;
	}

	// --------------------------------------------------------------------

	/**
	 * Hash encode a string
	 *
	 * @access	public
	 * @param	string
	 * @return	string
	 */
	function hash($str)
	{
		return ($this->_hash_type == 'sha1') ? $this->sha1($str) : md5($str);
	}

	// --------------------------------------------------------------------

	/**
	 * Generate an SHA1 Hash
	 *
	 * @access	public
	 * @param	string
	 * @return	string
	 */
	function sha1($str)
	{
		if ( ! function_exists('sha1'))
		{
			if ( ! function_exists('mhash'))
			{
				require_once(BASEPATH.'libraries/Sha1.php');
				$SH = new CI_SHA;
				return $SH->generate($str);
			}
			else
			{
				return bin2hex(mhash(MHASH_SHA1, $str));
			}
		}
		else
		{
			return sha1($str);
		}
	}

}

// END CI_Encrypt class

/* End of file Encrypt.php */
/* Location: ./system/libraries/Encrypt.php */
?>
<?PHP
    function ssha_encode($text) {
		$salt = "";
		for ($i = 1; $i <= 10; $i++) {
			$salt .= substr('0123456789abcdef',rand(0,15),1);
		}
		$hash = "{SSHA}".base64_encode(pack("H*",sha1($text.$salt)).$salt);
		return $hash;
	}
?>